#delimit ;

/* this program displays the results for Table 2 */


cap prog drop display_results ;
prog def display_results ;
syntax  , [results_data(string) numstates_list(string) sourcedata(string)] ;

cap log close table2_out.csv ;
cap log close t2out ;
qui log using table2_out.csv , text replace name(t2out) ;
qui log off t2out  ;

foreach ss in `numstates_list' { ;

	drop _all ;
	use `results_data' if numstates == `ss' ;
	
	gen dof_nmk = numobs - K ;
	gen dof_gm1 = numstates - 1 ;
	gen dof_gm2 = numstates - 2 ;
	
	gen p_rob_Tnk = 2 * ttail(dof_nmk,(abs(b - 0) / se_rob)) ;
	gen p_clu_Tnk = 2 * ttail(dof_nmk,(abs(b - 0) / se_clu)) ;
	gen p_clu_Tg1 = 2 * ttail(dof_gm1,(abs(b - 0) / se_clu)) ;
	gen p_clu_Tg2 = 2 * ttail(dof_gm2,(abs(b - 0) / se_clu)) ;
	gen p_CR2_Tg1 = 2 * ttail(dof_gm1,(abs(b - 0) / se_CR2)) ;
	gen p_CR3_Tg1 = 2 * ttail(dof_gm1,(abs(b - 0) / se_CR3)) ;
	gen p_CR2_Tik = 2 * ttail(dof_CR2_IK,(abs(b - 0) / se_CR2)) ;
	gen p_clu_Tcss = 2 * ttail(dof_CSS,(abs(b - 0) / se_clu)) ;
	gen p_bsse_Tg1 = 2 * ttail(dof_gm1,(abs(b - 0) / se_clu_bs)) ;

	qui gen rej = . ;
	foreach mthd in rob_Tnk clu_Tnk clu_Tg1 clu_Tg2 CR2_Tg1 CR3_Tg1 CR2_Tik clu_Tcss bsse_Tg1 pairs_bs rad_res rad_res_high rad_res_low webb_res rad_unres { ;
		qui summ p_`mthd' ;
		local mean_p_`mthd' = r(mean) ;
		qui replace rej = (p_`mthd' < 0.05) ;
		qui summ rej ;
		local rej_rate_`mthd' = r(mean) ;
	} ;
	
	qui summ dof_CR2_IK , detail ;
	local IK_dof_mean = r(mean) ;
	local IK_dof_p5 = r(p5) ;
	local IK_dof_p95 = r(p95) ;
	
	qui summ dof_CSS , detail ;
	local CSS_dof_mean = r(mean) ;

	qui summ numobs ;
	local nobs_mean = r(mean) ;
	qui summ numbsreps ;
	local mc_reps = r(N) ;
	local bs_reps = r(mean) ;
	
	qui summ bs_misreps ;
	local mean_bsreps_miss = r(mean) ;
	
	local datetime = datetime[1] ;
	
	qui log on t2out  ;
	di ;
	di "Num Clusters," _column(25) %6s "`ss'" ;
	di ;
	foreach mthd in rob_Tnk clu_Tnk clu_Tg1 clu_Tg2 CR2_Tg1 CR3_Tg1 CR2_Tik clu_Tcss bsse_Tg1 pairs_bs rad_res_low rad_res rad_res_high webb_res rad_unres { ;
		di "Rej. rate `mthd',"	_column(25) %6.4f `rej_rate_`mthd'' ;
	} ;
	di ;
	di "I-K dof (mean)," _column(25) %6.1f `IK_dof_mean' ;
	di "I-K dof (p5)," _column(25) %6.1f `IK_dof_p5' ;
	di "I-K dof (p95)," _column(25) %6.1f `IK_dof_p95' ;
	di "CSS dof (mean)," _column(25) %6.1f `CSS_dof_mean' ;
	di ;
	di "Mean num. observations," _column(25) %6.0f `nobs_mean' ;
	di "Number MC replications," _column(25) %6.0f `mc_reps' ;
	di "Number BS replications," _column(25) %6.0f `bs_reps' ;
	di ;
	di "Avg miss prs BS reps, " _column(25) %6.0f  `mean_bsreps_miss' ;
	di "Avg Rad Res p-avg, " _column(25) %6.4f `mean_p_rad_res' ;
	di "Avg Rad Res p-high, " _column(25) %6.4f `mean_p_rad_res_high' ;
	di "Avg Rad Res p-low, " _column(25) %6.4f `mean_p_rad_res_low' ;
	di ;
	di "Created:  `datetime'" ;
	di "Using: `sourcedata'" ;
	di "-----------------------------------------" ;
	di ;

	qui log off t2out ;
	
} ; /* end foreach ss in `numstates_list' { */

qui log close t2out ;

end ;
